﻿<%@ Import Namespace="Soneta.Kalend" %>
<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Urlopy na żądanie</title>
		<script runat="server">

	public class PrnParams: ContextBase {
	
		public PrnParams(Context context): base(context) {
			UstawRok();
		}
		
		FromTo okres;
		[Caption("Plan urlopów za okres")]
		public FromTo Okres {
			get { return okres; }
			set { 
				if (value==FromTo.Empty || value==FromTo.All)
					UstawRok();
				else
					okres = value; 
			}
		}	
		
		void UstawRok() {
			Date data;
			if (Context.Contains(typeof(ActualDate)))
				data = ((ActualDate)Context[typeof(ActualDate)]).Actual;
			else
				data = Date.Today;
			okres = FromTo.Year(data.Year);
		}		
	}
	
	PrnParams pars = null; 
	[Context(Required=true)] 
	public PrnParams Params { 
		get { return pars; } 
		set { pars = value; } 
	} 

	KalendModule kalend;
	DefinicjaLimitu definicja;
	
	void OnContextLoad(Object sender, EventArgs args) {
		if (pars.Okres==FromTo.Year(pars.Okres.To.Year))
			ReportHeader1["OKRES"] = "na " + pars.Okres.To.Year + " rok";
		else
			ReportHeader1["OKRES"] = "za okres " + pars.Okres.ToString();
	
		kalend = KalendModule.GetInstance(dc);
		definicja = kalend.DefinicjeLimitow.UrlopWypoczynkowy;
	}
	
    void Grid1_BeforeRow(Object sender, RowEventArgs args) {
		PracHistoria ph = (PracHistoria)args.Row;

		KalkulatorPracy kalk = new KalkulatorPracy(ph.Pracownik);
		IEnumerable nieobecności = kalk.Nieobecnosci(pars.Okres, true);
		ArrayList result = new ArrayList();
		foreach (OkresNieobecności n in nieobecności)
			if (n.Definicja.Przyczyna==PrzyczynaNieobecnosci.UrlopWypoczynkowy && n.Urlop.Przyczyna==PrzyczynaUrlopu.NaŻądanie)
				result.Add(n);

		string so = "";
		string sg = "";
		string sd = "";
        bool any = false;
        CzasDni cd = CzasDni.Empty;
        foreach (OkresNieobecności n in result) {
            any = true;
            CzasDni norma = n.Norma();
            cd += norma;
            so += n.Okres + "<br>";
            sg += norma.Czas + "<br>";
            sd += norma.Dni + "<br>";
        }

        if (any) {
            okres.EditValue = so + "<strong>Razem:</strong>";
            urlopG.EditValue = sg + "<strong>" + cd.Czas + "</strong>";
            urlopD.EditValue = sd + "<strong>" + cd.Dni + "</strong>";
        }
        else
            args.VisibleRow = false;
    }
    
	public static object Msg(object obj) {
		return obj;
	}

		</script>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="UrlopyPlan" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" TypeName="Soneta.Business.Row[], Soneta.Business"
				oncontextload="OnContextLoad"></ea:datacontext><cc1:reportheader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" title="Urlopy na żądanie %OKRES%" runat="server"></cc1:reportheader><ea:grid id="Grid1" runat="server" OnBeforeRow="Grid1_BeforeRow" RowTypeName="Soneta.Kadry.PracHistoria, Soneta.KadryPlace"
				LinkedRows="History">
				<Columns>
					<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="LP." ID="lp" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="20" DataMember="Etat.Wydzial.Kod" Caption="Nazwa działu zakładu pracy" NoWrap="True" runat="server"></ea:GridColumn>
					<ea:GridColumn DataMember="Pracownik.NazwiskoImię" Caption="Nazwisko i imię pracownika" NoWrap="True" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="21" Caption="Urlop wykorzystany~okres" HideZero="True" ID="okres"
						VAlign="Top" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="8" Align="Center" Caption="Urlop wykorzystany~godz." HideZero="True" ID="urlopG"
						VAlign="Top" runat="server"></ea:GridColumn>
                    <ea:GridColumn ID="urlopD" runat="server" Align="Center" Caption="Urlop wykorzystany~dni pracy"
                        Width="8">
                    </ea:GridColumn>
				</Columns>
			</ea:grid><cc1:reportfooter id="ReportFooter1" runat="server"></cc1:reportfooter></form>
	</body>
</HTML>
